package com.jumeirah.common.service;

import com.jumeirah.common.entity.MerchantRole;
import com.jumeirah.common.param.MerchantRolePageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.vo.MerchantRoleQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 商家角色 服务类
 *
 * @author wei
 * @since 2020-09-28
 */
public interface MerchantRoleService extends BaseService<MerchantRole> {

        /**
         * 保存
         *
         * @param merchantRole
         * @return
         * @throws Exception
         */
        boolean saveMerchantRole(MerchantRole merchantRole)throws Exception;

        /**
         * 修改
         *
         * @param merchantRole
         * @return
         * @throws Exception
         */
        boolean updateMerchantRole(MerchantRole merchantRole)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteMerchantRole(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        MerchantRoleQueryVo getMerchantRoleById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param merchantRolePageParam
         * @return
         * @throws Exception
         */
        Paging<MerchantRoleQueryVo> getMerchantRolePageList(MerchantRolePageParam merchantRolePageParam) throws Exception;

        }
