package com.wecloud.im.sdk.model;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 单个用户通知
 * @Author luozh
 * @Date 2022年05月05日 11:49
 * @Version 1.0
 */
@Builder
@Data
public class SingleUserNotification {
    /**
     * 发送人用户id
     */
    private String fromUserId;

    /**
     * 指定一个或多个用户
     */
    private String toUserIds;

    /**
     * 消息类型
     */
    private String messageType;

    /**
     * 消息
     */
    private String content;

    /**
     * 指定离线推送通知中的推送内容
     */
    private String pushContent;

    /**
     * 是否存储此条消息
     */
    private Boolean persisted;

    /**
     * 推送拓展配置
     */
    private PushExtParam pushExt;

    /**
     * 会话拓展配置
     */
    private ConversationExt conversationExt;

    @Tolerate
    public SingleUserNotification() {
    }
}
