package com.wecloud.im.sdk.sample;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import cn.hutool.core.date.DateUtil;

import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.common.auth.HmacSHA256Signature;
import com.wecloud.im.sdk.internal.ImHeaders;
import com.wecloud.im.sdk.internal.OSSRequestMessageBuilder;
import com.wecloud.im.sdk.internal.SignUtils;

/**
 *
 * @Author luozh
 * @Date 2022年04月14日 15:37
 * @Version 1.0
 */
public class SignTest {

    public static void main(String[] args) {

        String date = DateUtil.formatHttpDate(new Date());
        // 资源地址
        String resourcePath = "/api/imClient/registerClient";
        // 请求头
        Map<String, String> headers = new HashMap<>();
        headers.put(ImHeaders.DATE, date);
        headers.put(ImHeaders.CONTENT_TYPE, "application/json");
        // 请求参数
        Map<String, String> param = new HashMap<>();
        param.put("appKey", "appKey");
        param.put("userId", "1111222333");
        param.put("headPortrait", "");
        param.put("nickname", "罗罗啦");
        param.put("deviceType", "1");
        // 发送请求
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint("/api/imClient/registerClient")
                .setMethod(HttpMethod.POST).setParameters(param).addHeaders(headers)
                .setOriginalRequest(null).build();

        String canonicalString = SignUtils.buildCanonicalString("POST", resourcePath, request);
        String signature = new HmacSHA256Signature().computeSignature("secretAccessKey", canonicalString);
        String authorization = SignUtils.composeRequestAuthorization("accessKeyId", signature);
        System.out.println("canonicalString: " + canonicalString);
        System.out.println("signature: " + signature);
        System.out.println("Authorization header: " + authorization);

    }
}
