package com.wecloud.im.param.add;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * api添加会话成员
 *
 * @author wei
 * @since 2022年05月16日14:13:46
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImConversationMemAttrApiAdd")
public class ImConversationMemApiAdd extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "会话表id",required = true)
    private Long conversationId;

    @ApiModelProperty("操作者client ID,可为空")
    private String operator="";

    @ApiModelProperty(value = "被操作的client ID",required = true)
    private String passivityOperator;

    @ApiModelProperty("加入的类型, link或qrCode等")
    private String joinType="";
}
