package com.wecloud.im.controller.serverapi;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.param.add.ImConversationRestApiCreate;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImConversationService;
import com.wecloud.im.vo.ImConversationCreateVo;
import com.wecloud.im.vo.MyConversationListVo;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 会话表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/server/conversation")
@Api(value = "会话表API", tags = {"会话表"})
public class ApiImConversationController extends BaseController {

    @Autowired
    private ImConversationService imConversationService;

    @Autowired
    private ImApplicationService imApplicationService;


    /**
     * 服务端创建会话
     */
    @PostMapping("/create")
    @ApiOperation(value = "服务端创建会话", notes = "后台可配置:两个客户端如果已经创建过会话,是否重复创建会话")
    public ApiResult<ImConversationCreateVo> createImConversation(@RequestBody ImConversationRestApiCreate imConversationRestApiCreate
            , @RequestHeader String appkey, @RequestHeader String appSecret) throws Exception {

        //  根据appKey从数据库查询密钥
        ImApplication imApplication = imApplicationService.getOneByAppKey(appkey);

        if (imApplication == null) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        // 校验appkey 和appSecret
        if (!imApplication.getAppSecret().equals(appSecret)) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        return imConversationService.createImConversationRestApi(imConversationRestApiCreate, appkey, appSecret);
    }


    /**
     * 获取会话表详情
     */
    @GetMapping("/info")
    @ApiOperation(value = "会话表详情")
    public ApiResult<MyConversationListVo> getImConversation(@RequestParam("conversationId") Long conversationId
            , @RequestHeader String appkey, @RequestHeader String appSecret) throws Exception {

        //  根据appKey从数据库查询密钥
        ImApplication imApplication = imApplicationService.getOneByAppKey(appkey);

        if (imApplication == null) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        // 校验appkey 和appSecret
        if (!imApplication.getAppSecret().equals(appSecret)) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        MyConversationListVo imConversationQueryVo = imConversationService.getImConversationInfoByIdForServerApi(conversationId);
        return ApiResult.ok(imConversationQueryVo);
    }


}

