package com.wecloud.rtc;

import java.io.Serializable;

public class RtcRedisKey implements Serializable {

    /**
     * 维护所有用户当前在线的频道ID
     * new Map<String,Long> map
     * map.put("clientA",10001)
     * map.put("clientB",10001)
     * map.put("clientC",10002)
     * map.put("clientD",10003)
     * <p>
     * redis Key:
     * user_join_channel = ujc
     * rcu:clientA:10001
     * rcu:clientB:10001
     * rcu:clientC:10002
     * rcu:clientD:10003
     */
    public static final String USER_JOIN_CHANNEL = "ujc:%s:%s";

    /**
     * 维护频道中存在的用户
     * Map<Long,List<String>> map
     * <p>
     * new List<String> list
     * list.add("clientA")
     * list.add("clientB")
     * <p>
     * map.put(10001,list)
     * <p>
     * redis Key:
     * rtc_channel_users = rcu
     * key = rcu:10001:clientA
     * key = rcu:10001:clientB
     * key = rcu:10002:clientC
     * key = rcu:10003:clientD
     */
    public static final String RTC_CHANNEL_USERS = "rcu:%s:%s";


}
