package com.wecloud.im.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/9 17:25
 * @Description 呼叫类型枚举
 */
public enum CallTypeEnum implements BaseEnum {

    /**
     * 1 - video
     */
    VIDEO(1, "video"),

    /**
     * 2 - voice
     */
    VOICE(2, "voice");

    CallTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
