package io.geekidea.springbootplus.scheduled;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.entity.ImStatistics;
import com.wecloud.im.sdk.enums.ChatTypeEnum;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImConversationService;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.service.ImStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Component
public class OverviewScheduled {

    @Autowired
    private ImStatisticsService imStatisticsService;
    @Autowired
    private ImApplicationService imApplicationService;
    @Autowired
    private ImMessageService imMessageService;
    @Autowired
    private ImConversationService imConversationService;



    //统计数据统计中的数据并存入im_statistics表
    @Scheduled(cron = "0 0/5 * * * ? ")
    public void statisticsData(){
        log.info("正在记录前一天的数据统计");
        List<ImApplication> imApplicationList = imApplicationService.list();
        for (ImApplication imApplication : imApplicationList) {
            Long appId = imApplication.getId();
            //统计活跃用户数量并保存
            List<ImMessage> imMessageList = imMessageService.list(new LambdaQueryWrapper<ImMessage>()
                    .eq(ImMessage::getFkAppid, appId)
                    .between(ImMessage::getCreateTime,
                            LocalDateTime.of(LocalDate.now(), LocalTime.MIN).minusDays(1),
                            LocalDateTime.of(LocalDate.now(), LocalTime.MAX).minusDays(1))
                    .groupBy(ImMessage::getSender)
                    .select(ImMessage::getSender)
            );
            Integer activeUser = imMessageList.size();
            ImStatistics userStatistics = new ImStatistics();
            userStatistics.setData(activeUser);
            userStatistics.setFkAppid(appId);
            userStatistics.setTime(LocalDateTime.now().minusDays(1));
            userStatistics.setType(1);
            imStatisticsService.saveOrUpdate(userStatistics);

            //统计活跃群组数量并保存
            List<Long> ids = imMessageService.list(new LambdaQueryWrapper<ImMessage>()
                    .between(ImMessage::getCreateTime,
                            LocalDateTime.of(LocalDate.now(), LocalTime.MIN).minusDays(1),
                            LocalDateTime.of(LocalDate.now(), LocalTime.MAX).minusDays(1))
                    .groupBy(ImMessage::getFkConversationId)
                    .select(ImMessage::getFkConversationId)
            ).stream().map(ImMessage::getFkConversationId).collect(Collectors.toList());

            List<ImConversation> groupList = imConversationService.list(new LambdaQueryWrapper<ImConversation>()
                    .eq(ImConversation::getFkAppid, appId)
                    .eq(ImConversation::getChatType, ChatTypeEnum.NORMAL_GROUP.getCode())
                    .eq(ImConversation::getChatType, ChatTypeEnum.THOUSAND_GROUP.getCode())
                    .in(ImConversation::getId, ids)
            );
            Integer activeGroup = groupList.size();
            //活跃群的成员总数
            Integer groupMember = 0;
            for (ImConversation imConversation : groupList) {
                groupMember += imConversation.getMemberCount();
            }
            ImStatistics groupStatistics = new ImStatistics();
            groupStatistics.setData(activeGroup);
            groupStatistics.setFkAppid(appId);
            groupStatistics.setTime(LocalDateTime.now().minusDays(1));
            groupStatistics.setType(2);
            groupStatistics.setGroupMember(groupMember);
            imStatisticsService.saveOrUpdate(groupStatistics);
            log.info("数据保存结果为{}",imStatisticsService);
        }

    }
}
