package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.mapper.ImConversationMembersMapper;
import com.wecloud.im.param.ApiImConversationMembersPageParam;
import com.wecloud.im.param.ApiImConversationMembersQueryVo;
import com.wecloud.im.param.ImConversationMembersPageParam;
import com.wecloud.im.param.ImConversationMembersQueryVo;
import com.wecloud.im.service.ImConversationMembersService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 会话成员表 服务实现类
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@Service
public class ImConversationMembersServiceImpl extends BaseServiceImpl<ImConversationMembersMapper, ImConversationMembers> implements ImConversationMembersService {

    @Autowired
    private ImConversationMembersMapper imConversationMembersMapper;

    @Override
    public ApiResult<List<ApiImConversationMembersQueryVo>> getRestApiImConversationMembersList(ApiImConversationMembersPageParam apiImConversationMembersPageParam, ImApplication imApplication) {

        List<ApiImConversationMembersQueryVo> restApiImConversationMembersList = imConversationMembersMapper.getRestApiImConversationMembersList(apiImConversationMembersPageParam.getConversationId());
        return ApiResult.ok(restApiImConversationMembersList);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveImConversationMembers(ImConversationMembers imConversationMembers) throws Exception {
        return super.save(imConversationMembers);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateImConversationMembers(ImConversationMembers imConversationMembers) throws Exception {
        return super.updateById(imConversationMembers);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteImConversationMembers(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public ImConversationMembersQueryVo getImConversationMembersById(Long id) throws Exception {
        return imConversationMembersMapper.getImConversationMembersById(id);
    }

    @Override
    public Paging<ImConversationMembersQueryVo> getImConversationMembersPageList(ImConversationMembersPageParam imConversationMembersPageParam) throws Exception {
        Page<ImConversationMembersQueryVo> page = new PageInfo<>(imConversationMembersPageParam, OrderItem.desc(getLambdaColumn(ImConversationMembers::getCreateTime)));
        IPage<ImConversationMembersQueryVo> iPage = imConversationMembersMapper.getImConversationMembersPageList(page, imConversationMembersPageParam);
        return new Paging<ImConversationMembersQueryVo>(iPage);
    }

}
