package com.wecloud.im.service;

import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.GetClientInfoParam;
import com.wecloud.im.param.ImClientPageParam;
import com.wecloud.im.param.ImClientQueryVo;
import com.wecloud.im.param.add.ImClientDeviceInfoAdd;
import com.wecloud.im.param.add.ImClientHeadPortraitAdd;
import com.wecloud.im.param.add.ImClientNicknameAdd;
import com.wecloud.im.vo.GetInfoListVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 终端表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImClientService extends BaseService<ImClient> {

    boolean updateHeadPortrait(ImClientHeadPortraitAdd imClientHeadPortraitAdd) throws Exception;


    /**
     * 根据ids获取Client的头像昵称
     *
     * @param getClientInfoParam
     * @return
     * @throws Exception
     */
    ApiResult<List<GetInfoListVo>> getInfoList(GetClientInfoParam getClientInfoParam) throws Exception;


    boolean updateNickname(ImClientNicknameAdd imClientNicknameAdd) throws Exception;

    /**
     * 保存
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean saveImClient(ImClient imClient) throws Exception;

    /**
     * 添加或修改推送设备信息
     *
     * @param imClientDevice
     * @return
     */
    boolean updateDeviceInfo(ImClientDeviceInfoAdd imClientDevice);

    boolean logout();


    /**
     * 修改
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean updateImClient(ImClient imClient) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImClient(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImClientQueryVo getImClientById(Long id) throws Exception;

    /**
     * 移除旧的设备token
     *
     * @param appId
     * @param deviceToken
     * @return
     */
    int removeOldToken(Long appId, String deviceToken);

    /**
     * 获取分页对象
     *
     * @param imClientPageParam
     * @return
     * @throws Exception
     */
    Paging<ImClientQueryVo> getImClientPageList(ImClientPageParam imClientPageParam) throws Exception;


    /**
     * 获取当前请求的client对象
     *
     * @return
     */
    ImClient getCurentClient();

    ImClient getCacheImClient(Long applicationId, String clientId);

    void deleteCacheImClient(Long applicationId, String clientId);

}
