package com.wecloud.rtc.service.impl;

import com.wecloud.im.ws.utils.RedisUtils;
import com.wecloud.rtc.RtcRedisKey;
import com.wecloud.rtc.service.MangerRtcChannelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Service
public class MangerRtcChannelServiceImpl implements MangerRtcChannelService {

    @Autowired
    private RedisUtils redisUtils;

    @Override
    public Long create(String appKey, String clientId, Long rtcChannelId) {

        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId, rtcChannelId);

        //频道中存在的用户
        String rtcChannelUsersKey = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId, appKey + clientId);

        redisUtils.setKey(userJoinChannelKey, "");
        redisUtils.setKey(rtcChannelUsersKey, "");
        return null;
    }

    @Override
    public void join(String appKey, String clientId, Long rtcChannelId) {

        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId, rtcChannelId);

        //频道中存在的用户
        String rtcChannelUsersKey = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId, appKey + clientId);

        redisUtils.setKey(userJoinChannelKey, "");
        redisUtils.setKey(rtcChannelUsersKey, "");


    }

    @Override
    public void remove(String appKey, String clientId, Long rtcChannelId) {


        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId, rtcChannelId);

        //频道中存在的用户
        String rtcChannelUsersKey = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId, appKey + clientId);

        redisUtils.delKey(userJoinChannelKey);
        redisUtils.delKey(rtcChannelUsersKey);

    }

    @Override
    public List<String> getClientListByRtcChannelId(Long rtcChannelId) {

        String rtcChannelUsersKey = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId, "*");
        Set<String> keys = redisUtils.keys(rtcChannelUsersKey);

        List<String> clientList = new ArrayList<>();
        for (String next:keys){
            String s = next.split(":")[2];

            clientList.add(s);
        }
        return clientList;

    }

    @Override
    public Long getRtcChannelIdListByClientId(String appKey, String clientId) {

        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId, "*");
        Set<String> keys = redisUtils.keys(userJoinChannelKey);
        String next = keys.iterator().next();

        return Long.valueOf(next.split(":")[2]);
    }

    @Override
    public boolean getBusyStatus(String appKey, String clientId) {

        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId, "*");
        Set<String> keys = redisUtils.keys(userJoinChannelKey);

        if (keys == null || keys.isEmpty()) {
            return false;
        } else {
            return true;
        }

    }
}
