package com.wecloud.rtc.service;

import java.util.List;

/**
 * 管理rtc频道
 */
public interface MangerRtcChannelService {

    /**
     * 创建一个频道
     */
    Long create(String appKey, String clientId, Long rtcChannelId);

    /**
     * 加入频道
     */
    void join(String appKey, String clientId, Long rtcChannelId);

    /**
     * 退出频道
     */
    void remove(String appKey, String clientId, Long rtcChannelId);

    /**
     * 根据频道ID获取频道内所有client
     */
    List<String> getClientListByRtcChannelId(Long rtcChannelId);

    /**
     * 根据客户端ID获取该客户端加入的频道ID
     */
    Long getRtcChannelIdListByClientId(String appKey, String clientId);

    /**
     * 获取客户端忙线/空闲状态
     * @param appKey
     * @param clientId
     * @return true:忙线,false空闲
     */
    boolean getBusyStatus(String appKey, String clientId);

}
