package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.mapper.ImInboxMapper;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.vo.ConversationCountVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 消息收件箱表 服务实现类
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@Service
public class ImInboxServiceImpl extends BaseServiceImpl<ImInboxMapper, ImInbox> implements ImInboxService {

    @Autowired
    private ImInboxMapper imInboxMapper;

    @Autowired
    private ImClientService imClientService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateImMsgReceived(ImMsgReceivedStatusUpdate imMsgReceivedUpdate) {
        ImClient curentClient = imClientService.getCurrentClient();
        // 修改已接收状态
//        imInboxMapper.updateImMsgReceivedByIds(curentClient.getId(), imMsgReceivedUpdate.getMsgIds());
        // 修改已读状态
        imInboxMapper.updateImMsgReadByIds(curentClient.getId(), imMsgReceivedUpdate.getMsgIds());
        return true;
    }

    /**
     * 统计未读消息数量
     *
     * @param fkClientId
     * @return
     */
    @Override
    public List<ConversationCountVo> countNotRead(Long fkClientId) {
        return imInboxMapper.countMyNotRead(fkClientId);
    }

    @Override
    public List<ConversationCountVo> countBeAt(ImClient imClient) {
        return imInboxMapper.countBeAt(imClient.getId(), imClient.getClientId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateImMsgRead(MsgReadStatusUpdateParam msgReadStatusUpdateParam) {
        // 小虎豆不做单条消息修改已读
        ImClient curentClient = imClientService.getCurrentClient();
        // 修改已读状态
        imInboxMapper.updateImMsgReadByIds(curentClient.getId(), msgReadStatusUpdateParam.getMsgIds());
        return true;

    }

    @Override
    public Boolean updateMsgReadStatusByConversation(UpdateMsgReadStatusByConversationParam param) {
        ImClient currentClient = imClientService.getCurrentClient();
        this.remove(new QueryWrapper<ImInbox>().lambda()
                .eq(ImInbox::getFkConversationId, param.getConversationId())
                .le(ImInbox::getFkMsgId, param.getMsgIdEnd())
                .eq(ImInbox::getReceiver, currentClient.getId()));
        return true;
    }


}
