package com.wecloud.im.service;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ChatRoomMemberPageParam;
import com.wecloud.im.param.DisbandConversationParam;
import com.wecloud.im.param.ExitChatRoomParam;
import com.wecloud.im.param.GroupChatSettingParam;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.param.IntoChatRoomParam;
import com.wecloud.im.param.ListConversationParam;
import com.wecloud.im.param.MutedGroupMemberParam;
import com.wecloud.im.param.MutedGroupParam;
import com.wecloud.im.param.SetAdminsParam;
import com.wecloud.im.param.SetHeadPortraitParam;
import com.wecloud.im.param.TransferOwnerParam;
import com.wecloud.im.param.add.ImClientLeaveConversation;
import com.wecloud.im.param.add.ImClientToConversation;
import com.wecloud.im.param.add.ImConversationAttrUpdate;
import com.wecloud.im.param.add.ImConversationCreate;
import com.wecloud.im.param.add.ImConversationDisplayUpdate;
import com.wecloud.im.param.add.ImConversationNameUpdate;
import com.wecloud.im.param.add.ServerImConversationCreate;
import com.wecloud.im.vo.ChatRoomMemberVo;
import com.wecloud.im.vo.ConversationVo;
import com.wecloud.im.vo.ImConversationCreateVo;

/**
 * 会话表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationService extends BaseService<ImConversation> {

    /**
     * 保存
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean saveImConversation(ImConversation imConversation) throws Exception;


    /**
     * 创建会话
     *
     * @param imConversationCreate
     * @return
     */
    ImConversationCreateVo createImConversation(ImConversationCreate imConversationCreate);

    /**
     * 创建会话 sdk用
     *
     * @param imConversationCreate
     * @return
     */
    ImConversation serverCreateImConversation(ServerImConversationCreate imConversationCreate);


    /**
     * 将用户添加进会话
     *
     * @param imClientToConversation
     * @return
     * @throws JsonProcessingException
     */
    Boolean addClientToConversation(ImClientToConversation imClientToConversation);

    /**
     * 将client从会话移除
     *
     * @param imClientToConversation
     * @return
     */
    Boolean delClientToConversation(ImClientToConversation imClientToConversation) throws Exception;

    /**
     * 解散群聊
     * @param param
     * @return
     */
    void disband(DisbandConversationParam param);

    /**
     * client退出会话
     */
    Boolean leaveConversation(ImClientLeaveConversation imClientToConversation);

    /**
     * 群主转让
     * @param param
     * @return
     */
    Boolean transferOwner(TransferOwnerParam param);

    /**
     * 设置管理员
     * @param param
     * @return
     */
    Boolean setAdmins(SetAdminsParam param);

    /**
     * 群禁言
     * @param param
     * @return
     */
    Boolean mutedGroup(MutedGroupParam param);

    /**
     * 选择禁言
     * @param param
     * @return
     */
    Boolean mutedGroupMember(MutedGroupMemberParam param);

    /**
     * 判断当前操作人是否为指定角色成员
     * @param currentClientId
     * @param conversationId
     * @param roles
     * @return
     */
    Boolean isBelongToRole(String currentClientId, Long conversationId, List<Integer> roles);

    /**
     * 添加或修改会话名称
     */
    ApiResult<Boolean> saveOrUpdateName(ImConversationNameUpdate imConversationNameUpdate);

    /**
     * 添加或修改会话拓展字段
     */
    void saveOrUpdateAttr(ImConversationAttrUpdate imConversationAttrUpdate);

    /**
     * 修改
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean updateImConversation(ImConversation imConversation);

    /**
     * 修改为 是否单向隐藏会话","云端聊天记录不删除;假设有A和B两个用户,A删会话,B还能发; 如果B发了消息,A这边要重新把会话显示出来,并能显示之前的聊天记录"
     *
     * @return
     * @throws Exception
     */
    boolean updateDisplayConversation(ImConversationDisplayUpdate imConversationDisplayUpdate);

    /**
     * 根据ID获取查询对象 (redis缓存)
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImConversationQueryVo getCacheImConversationById(Long id);

    /**
     * 删除redis中该会话的缓存
     *
     * @param id
     */
    void deleteCacheImConversationById(Long id);


    /**
     * 获取分页对象
     *
     * @param imConversationPageParam
     * @return
     * @throws Exception
     */
    Paging<ImConversationQueryVo> getImConversationPageList(ImConversationPageParam imConversationPageParam);


    /**
     * 查询用户加入的所有会话 与每个会话的未读条数
     *
     * @return
     * @throws Exception
     */
    List<ConversationVo> getMyImConversationListAndMsgCount();

    /**
     * 根据会话id查询单个会话信息 与会话的未读条数
     * @param param
     * @return
     */
    ConversationVo infoImConversationAndMsgCount(ImConversationQueryParam param);

    /**
     * 获取加入的所有会话
     *
     * @return
     * @throws Exception
     */
    List<ImConversation> getMyImConversationList();

    /**
     * 判断重复会话中的Attributes是否一样
     *
     * @param clientId1
     * @param clientId2
     * @param attributes
     * @return 大于等于1为有重复会话
     */
    Long getRepetitionConversationAttributes(Long clientId1, Long clientId2, String attributes);

    /**
     * 群聊设置
     * @param param
     * @return
     */
    Boolean groupChatSetting(GroupChatSettingParam param);

    /**
     * 群聊设置
     * @param param
     * @return
     */
    Boolean groupChatSettingForSdk(GroupChatSettingParam param);

    /**
     * 群头像设置
     * @param param
     * @return
     */
    Boolean setHeadPortrait(SetHeadPortraitParam param);

    /**
     * 用户主动进入聊天室
     * @param param
     * @return
     */
    Boolean intoChatRoom(IntoChatRoomParam param);

    /**
     * 用户离开聊天室
     * @param param
     * @return
     */
    Boolean exitChatRoom(ExitChatRoomParam param);

    /**
     * 获取聊天室成员入参
     * @param param
     * @return
     */
    List<ChatRoomMemberVo> listChatRoomMember(ChatRoomMemberPageParam param);

    /**
     * 获取会话信息
     * @param param
     * @return
     */
    List<ConversationVo> listConversation(ListConversationParam param);

    /**
     * @param senderClientId
     * @param receiverClientIds
     * @Author luozh
     * @Date 2022年05月06日 07:18:34
     * @Return
     */
    List<ImConversation> getConversationBySenderAndReceivers(Long senderImClientId, Collection<Long> receiverImClientIds);

    /**
     * 给群成员发消息
     * @Author luozh
     * @Date 2022年05月10日 05:47:36
     * @param conversationId
     * @param membersList
     * @param appId
     * @param sender
     * @param content
     * @param message
     * @Return
     */
    void sendMsgToMembers(ImConversation conversation, List<ImConversationMembers> membersList, ImClient sender,
                          ImMessage message, Object content);


}
