package com.wecloud.im.param;

import lombok.Builder;
import lombok.Data;

/**
 *
 * @Author luozh
 * @Date 2022年04月22日 11:07
 * @Version 1.0
 */
@Builder
@Data
public class ClientOnlineStatusChangeDto {

    /**
     * 用户id
     */
    private String userId;

    /**
     * 状态：0：online 上线、1：offline 离线、2：logout 登出。
     */
    private Integer status;

    /**
     * 操作系统：iOS、Android、Websocket、PC、MiniProgram（小程序），用户上线时同步。
     */
    private String os;

    /**
     * 发生时间
     */
    private Long time;

    /**
     * 用户当前的 IP 地址及端口。
     */
    private String clientIp;
}
