package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 终端表
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImClient对象")
public class ImClient extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "客户端id不能为空")
    @ApiModelProperty("客户端id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后离线时间")
    private Date lastOfflineTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("可选	自定义属性，供开发者扩展使用。")
    private String attributes;

    @ApiModelProperty("客户方提供的唯一id")
    private String clientId;

    @ApiModelProperty("头像")
    private String headPortrait;

    @ApiModelProperty("主昵称")
    private String nickname;

}
