package com.wecloud.im.controller;

import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ImConversationMembersListParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.vo.ImConversationMemberListVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 会话成员表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/imConversationMembers")
@Api(value = "会话成员表API", tags = {"会话成员表"})
public class ImConversationMembersController extends BaseController {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    /**
     * 添加或修改会话成员备注
     */
    @PostMapping("/updateClientRemarkName")
    @ApiOperation(value = "添加或修改会话成员备注", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateClientRemarkName(@RequestBody ImConvMemeClientRemarkNameParam imConvMemeClientRemarkNameParam) throws Exception {
        return imConversationMembersService.saveOrUpdateClientRemarkName(imConvMemeClientRemarkNameParam);
    }


    /**
     * 添加或修改会话成员拓展字段
     */
    @PostMapping("/updateAttr")
    @ApiOperation(value = "添加或修改会话成员拓展字段", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateAttr(@RequestBody ImConversationMemAttrUpdate imConversationMemAttrUpdate) throws Exception {
        return imConversationMembersService.saveOrUpdateAttr(imConversationMemAttrUpdate);
    }


    /**
     * 会话中成员表列表
     */
    @PostMapping("/getList")
//    @OperationLog(name = "会话中成员表列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "获取会话中成员表列表")
    public ApiResult<List<ImConversationMemberListVo>> getImConversationMembersList(@Validated @RequestBody ImConversationMembersListParam imConversationMembersListParam) throws Exception {
//        Paging<ImConversationMembersQueryVo> paging = imConversationMembersService.getImConversationMembersPageList(imConversationMembersPageParam);
//        return ApiResult.ok(paging);
        return ApiResult.ok(imConversationMembersService.getImConversationMembersList(imConversationMembersListParam));
    }

//    /**
//     * 添加会话成员表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加会话成员表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加会话成员表")
//    public ApiResult<Boolean> addImConversationMembers(@Validated(Add.class) @RequestBody ImConversationMembers imConversationMembers) throws Exception {
//        boolean flag = imConversationMembersService.saveImConversationMembers(imConversationMembers);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改会话成员表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改会话成员表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改会话成员表")
//    public ApiResult<Boolean> updateImConversationMembers(@Validated(Update.class) @RequestBody ImConversationMembers imConversationMembers) throws Exception {
//        boolean flag = imConversationMembersService.updateImConversationMembers(imConversationMembers);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除会话成员表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除会话成员表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除会话成员表")
//    public ApiResult<Boolean> deleteImConversationMembers(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imConversationMembersService.deleteImConversationMembers(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取会话成员表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "会话成员表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "会话成员表详情")
//    public ApiResult<ImConversationMembersQueryVo> getImConversationMembers(@PathVariable("id") Long id) throws Exception {
//        ImConversationMembersQueryVo imConversationMembersQueryVo = imConversationMembersService.getImConversationMembersById(id);
//        return ApiResult.ok(imConversationMembersQueryVo);
//    }
//
//    /**
//     * 会话成员表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "会话成员表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "会话成员表分页列表")
//    public ApiResult<Paging<ImConversationMembersQueryVo>> getImConversationMembersPageList(@Validated @RequestBody ImConversationMembersPageParam imConversationMembersPageParam) throws Exception {
//        Paging<ImConversationMembersQueryVo> paging = imConversationMembersService.getImConversationMembersPageList(imConversationMembersPageParam);
//        return ApiResult.ok(paging);
//    }

}

