/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2019-2024. All rights reserved.
 */
package com.wecloud.im.push.huawei.util;


import com.wecloud.im.push.huawei.messaging.HuaweiApp;
import com.wecloud.im.push.huawei.messaging.HuaweiCredential;
import com.wecloud.im.push.huawei.messaging.HuaweiOption;


public class InitAppUtils {
    /**
     * @return HuaweiApp
     */
//    public static HuaweiApp initializeApp() {
//        String appId = ResourceBundle.getBundle("url").getString("appid");
//        String appSecret = ResourceBundle.getBundle("url").getString("appsecret");
//        // Create HuaweiCredential
//        // This appId and appSecret come from Huawei Developer Alliance
//        return initializeApp(appId, appSecret);
//    }

    public static HuaweiApp initializeApp(String appId, String appSecret,String tokenServer,String pushOpenUrl) {
        HuaweiCredential credential = HuaweiCredential.builder()
                .setAppId(appId)
                .setAppSecret(appSecret)
                .setTokenServer(tokenServer)
                .setPushOpenUrl(pushOpenUrl)
                .build();

        // Create HuaweiOption
        HuaweiOption option = HuaweiOption.builder()
                .setCredential(credential)
                .build();

        // Initialize HuaweiApp
//        return HuaweiApp.initializeApp(option);
        return HuaweiApp.getInstance(option);
    }
}
