package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.param.PlainTypePageParam;
import com.jumeirah.common.vo.PlainTypeQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 飞机型号表 Mapper 接口
 *
 * @author wei
 * @since 2020-10-09
 */
@Repository
public interface PlainTypeMapper extends BaseMapper<PlainType> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    PlainTypeQueryVo getPlainTypeById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param plainTypePageParam
     * @return
     */
    IPage<PlainTypeQueryVo> getPlainTypePageList(@Param("page") Page page, @Param("param") PlainTypePageParam plainTypePageParam);

}
