package com.wecloud.im.sdk.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/3/15 23:16
 * @Description 多人音视频房间成员状态枚举
 */
public enum MultiRtcMemberStateEnum implements BaseEnum {

    /**
     * 1 - 呼叫中
     */
    CALLING(1, "呼叫中"),

    /**
     * 2 - 已接听
     */
    ANSWERED(2, "已接听"),

    /**
     * 3 - 已拒绝
     */
    REJECTED(3, "已拒绝"),

    /**
     * 4 - 未接听
     */
    NOT_ANSWERED(4, "未接听"),

    /**
     * 5 - 已断开(断网断线)
     */
    DISCONNECT(5, "已断开"),

    /**
     * 6 - 主动退出
     */
    LEAVE(6, "主动退出");

    MultiRtcMemberStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
