# 卓美亚航空 - 后端项目

## 框架介绍
> 本项目使用第三方开源脚手架项目: spring-boot-plus 参考:README-zh.md


## 项目结构
```text
    └── spring-boot-plus
    ├── admin               SpringBootAdmin Server服务监控模块
    ├── bootstrap           spring-boot-plus 启动模块
    ├── config              配置模块
    ├── distribution        打包模块
    ├── docs                文档目录
    ├── framework           框架核心模块
    ├── generator           代码生成模块
    ├── scheduled           任务调度模块
    └── api-system          平台管理系统api模块
    └── api-app             app的api模块
    └── api-merchant        商家api服务模块
    └── common              通用模块(包含service dao mapper)
```
## 安装中间件
redis(必须本地开启)

mysql5.7 (你本地可以不开,在本地配置中已经连上了测试环境)





## 开发规范

### 关于模块
api-system    api-app   api-merchant 

三个模块是各自针对不同后端模块的api接口,都包含common模块的依赖,

你只能在其中开发模块属于自己的controller和service,

并且可以实现当前模块的service业务逻辑层,但对数据库操作,请一定调用common模块的service,不要在api-XXX的模块下写数据库的操作. 

如果业务流程没有很复杂, 在controller类中你可以直接调用common模块的service

### 例如:
#### 商户注册
在api-merchant模块中的controller包下新建一个Register控制器,

模块下每个控制器url路径必须要加上前缀```"/merchant/"```,这样为了方便权限控制

像这样:
```
@RequestMapping("/merchant/register/")
```

注册业务逻辑要调用common模块中的service去操作


#### app注册
在api-app模块中的controller包下新建一个Register控制器,

模块下每个控制器url路径必须要加上前缀```"/app/"```,这样为了方便权限控制

像这样:
```
@RequestMapping("/app/register/")
```

注册业务逻辑要调用common模块中的service去操作




