package com.jumeirah.api.app.entity.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

/**
 * 行程表-返程
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "添加返程行程入参对象")
public class StrokeAddBackAndForthParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "出发城市id不能为空")
    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @NotNull(message = "到达城市id不能为空")
    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @NotNull(message = "人数不能为空")
    @ApiModelProperty("人数")
    private Integer peopleNum;

    @ApiModelProperty("用户选择机型(多个中间逗号隔开)")
    private String choosePlainType;

    @NotNull(message = "出发时间不能为空")
    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

    @NotNull(message = "返程时间不能为空")
    @ApiModelProperty("返程时间")
    private Timestamp returnTime;

}
