package com.wecloud.im.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 注册客户端入参
 * @Author luozh
 * @Date 2022年04月13日 17:16
 * @Version 1.0
 */
@Data
public class RegisterClientParam {

    /**
     * app 用户id
     */
    @NotNull(message = "用户id 不能为空")
    @ApiModelProperty("用户id")
    private Long userId;

    /**
     * 头像
     */
    @ApiModelProperty("头像")
    private String headPortrait;

    /**
     * 昵称
     */
    @ApiModelProperty("昵称")
    private String nickname;

    /**
     * 设备类型
     */
    @NotNull(message = "设备类型 不能为空")
    @ApiModelProperty("设备类型")
    private Integer deviceType;
}
