package com.wecloud.im.controller;

import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.service.ImClientBlacklistService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 黑名单 控制器
 *
 * @author wei
 * @since 2021-06-17
 */
@Slf4j
@RestController
@RequestMapping("/ClientBlacklist")
@Api(value = "黑名单API", tags = {"黑名单"})
public class ImClientBlacklistController extends BaseController {

    @Autowired
    private ImClientBlacklistService imClientBlacklistService;

    /**
     * 添加黑名单
     */
    @PostMapping("/add")
    @ApiOperation(value = "拉入黑名单")
    public ApiResult<Boolean> addImClientBlacklist(@Validated(Add.class) @RequestBody ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        return imClientBlacklistService.addImClientBlacklist(imClientBlacklistUpdate);
    }


    /**
     * 删除黑名单
     */
    @PostMapping("/delete")
    @ApiOperation(value = "移出黑名单")
    public ApiResult<Boolean> deleteImClientBlacklist(@RequestBody ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        return imClientBlacklistService.removeImClientBlacklist(imClientBlacklistUpdate);
    }

    /**
     * 黑名单分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "黑名单分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "黑名单分页列表")
    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(@RequestBody ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {
        return imClientBlacklistService.getImClientBlacklistPageList(imClientBlacklistPageParam);
    }

}

