package com.wecloud.im.action;

import com.alibaba.fastjson.JSON;
import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.dispatch.extend.ActionRequest;
import com.wecloud.im.param.GetReadersParam;
import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.MsgDeleteParam;
import com.wecloud.im.param.add.ImMsgRecall;
import com.wecloud.im.param.add.ImMsgUpdate;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.vo.OfflineMsgDto;
import com.wecloud.im.vo.ReaderList;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.im.ws.sender.ChannelSender;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.netty.channel.socket.nio.NioSocketChannel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author wenzhida
 * @Date 2022/2/23 17:14
 * @Description 长连接方式处理消息
 */
@Slf4j
@Component
@ActionMapping(value = "/imMessage")
public class MessageAction {

    @Autowired
    private ImMessageService imMessageService;

    @Autowired
    private ChannelSender channelSender;

    /**
     * 消息撤回
     * @param request
     * @param msgRecall
     * @param reqId
     */
    @ActionMapping("/withdraw")
    public void withdraw(ActionRequest request, ImMsgRecall msgRecall, String reqId) {
        log.info("撤回消息内容：{}", JSON.toJSONString(msgRecall));
        WsResponse<Boolean> wsResponse = new WsResponse<>();
        wsResponse.setData(imMessageService.withdrawMsg(request, msgRecall));
        channelSender.sendMsgLocal((NioSocketChannel)request.getSenderChannel(), wsResponse);
    }

    /**
     * 删除消息内容
     * @param request
     * @param msgDeleteParam
     * @param reqId
     */
    @ActionMapping("/delete")
    public void deleteMsg(ActionRequest request, MsgDeleteParam msgDeleteParam, String reqId) {
        log.info("删除消息内容：{}", JSON.toJSONString(msgDeleteParam));
        WsResponse<Boolean> wsResponse = new WsResponse<>();
        wsResponse.setData(imMessageService.deleteMsg(request, msgDeleteParam));
        channelSender.sendMsgLocal((NioSocketChannel)request.getSenderChannel(), wsResponse);
    }

    /**
     * 修改消息体
     * @param request
     * @param imMsgUpdate
     * @param reqId
     */
    @ActionMapping("/updateMsgById")
    public void updateMsgById(ActionRequest request, ImMsgUpdate imMsgUpdate, String reqId) {
        log.info("修改消息内容：{}", JSON.toJSONString(imMsgUpdate));
        WsResponse<Boolean> wsResponse = new WsResponse<>();
        wsResponse.setData(imMessageService.updateMsgById(imMsgUpdate));
        channelSender.sendMsgLocal((NioSocketChannel)request.getSenderChannel(), wsResponse);
    }

    /**
     * 查询某个会话历史消息分页列表
     * @param request
     * @param param
     * @param reqId
     */
    @ActionMapping("/getHistoryMsg")
    public void getHistoryMsg(ActionRequest request, ImHistoryMessagePageParam param, String reqId) {
        log.info("查询某个会话历史消息分页列表：{}", JSON.toJSONString(param));
        WsResponse<Paging<OfflineMsgDto>> wsResponse = new WsResponse<>();
        wsResponse.setData(imMessageService.getHistoryMsgConversationId(param));
        channelSender.sendMsgLocal((NioSocketChannel)request.getSenderChannel(), wsResponse);
    }

    /**
     * 查询某个消息已读client列表和未读client
     * @param request
     * @param param
     * @param reqId
     */
    @ActionMapping("/getReaders")
    public void getReaders(ActionRequest request, GetReadersParam param, String reqId) {
        log.info("查询某个消息已读client列表和未读client：{}", JSON.toJSONString(param));
        WsResponse<ReaderList> wsResponse = new WsResponse<>();
        wsResponse.setData(imMessageService.getReaders(request, param));
        channelSender.sendMsgLocal((NioSocketChannel)request.getSenderChannel(), wsResponse);
    }

}
