package com.wecloud.im.sdk;

import java.util.List;

import com.wecloud.im.sdk.model.Friend;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.Token;
import com.wecloud.im.sdk.model.UnsureFriend;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:09
 * @Version 1.0
 */
public interface WecloudIm {

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 04:25:52
     * @param userId
     * @param headPortrait
     * @param nickname
     * @param deviceType
     * @Return
     * @return
     */
    ImClient registerClient(String userId, String headPortrait, String nickname);

    /**
     * 获取用户token
     * @Author luozh
     * @Date 2022年04月18日 11:50:44
     * @param userId 用户id
     * @param deviceType 设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac
     * @Return
     */
    Token getToken(String userId, Integer deviceType);


    /**
     * 修改用户
     * @Author luozh
     * @Date 2022年04月18日 03:29:52
     * @param userId 用户id
     * @param nickname 昵称
     * @param headPortrait 头像
     * @Return
     */
    Boolean modifyUser(String userId, String nickname, String headPortrait);

    /**
     * 获取好友请求列表
     * @Author luozh
     * @Date 2022年04月21日 04:50:57
     * @param userId 用户id
     * @Return
     */
    List<UnsureFriend> getUnsureFriends(String userId);

    /**
     * 获取所有好友列表
     * @Author luozh
     * @Date 2022年04月22日 11:45:15
     * @param userId 用户id
     * @Return
     */
    List<Friend> getFriends(String userId);

    /**
     * 设置会话置顶
     * @Author luozh
     * @Date 2022年04月26日 03:33:44
     * @param userId 用户id
     * @param conversationId 会话id
     * @param top 是否置
     * @Return
     */
    Boolean setConversationTop(String userId, Long conversationId, Boolean top);

    /**
     * 设置会话免打扰
     * @Author luozh
     * @Date 2022年04月26日 03:33:44
     * @param userId 用户id
     * @param conversationId 会话id
     * @param doNotDisturb 是否免打扰
     * @Return
     */
    Boolean setConversationDoNotDisturb(String userId, Long conversationId, Boolean doNotDisturb);
}
