package com.wecloud.im.sdk.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.RegisterClientRequest;

import static com.wecloud.im.sdk.utils.CodingUtils.assertParameterNotNull;

/**
 * client
 * @Author luozh
 * @Date 2022年04月13日 15:26
 * @Version 1.0
 */
public class WecloudImClientOperation extends WecloudImOperation {

    public WecloudImClientOperation(URL apiDomain, String appKey, String appSecret) {
        super(apiDomain, appKey, appSecret);
    }

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 03:38:58
     * @param registerClientRequest
     * @Return
     */
    public ImClient registerClient(RegisterClientRequest registerClientRequest) {
        Long userId = registerClientRequest.getUserId();
        // 参数校验
        assertParameterNotNull(userId, "userId");
        // 校验通过 构建参数
        Map<String, String> param = new HashMap<>();
        param.put("appKey", appKey);
        param.put("userId", registerClientRequest.getUserId() + "");
        param.put("headPortrait", registerClientRequest.getHeadPortrait());
        param.put("nickname", registerClientRequest.getNickname());
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint("/api/imClient/registerClient")
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(registerClientRequest).build();

        JSONObject result = doOperation(request);
        ImClient imClient = JSON.parseObject(result.toJSONString(), ImClient.class);
        return imClient;
    }
}
