package com.wecloud.im.sdk;

import java.net.URL;

import com.wecloud.im.sdk.internal.WecloudImClientOperation;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.RegisterClientRequest;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:23:24
 * @Version 1.0
 */
public class WecloudImClient implements WecloudIm {

    /**
     * 请求地址
     */
    private URL apiDomain;

    /**
     * 蔚可云分配后台分配的appKey
     */
    private String appKey;

    /**
     * 蔚可云分配后台分配的appSecret
     */
    private String appSecret;

    /* The miscellaneous OSS operations */
    private WecloudImClientOperation imClientOperation;

    public WecloudImClient(URL apiDomain, String appKey, String appSecret) {
        this.apiDomain = apiDomain;
        this.appKey = appKey;
        this.appSecret = appSecret;
        initOperations();
    }

    @Override
    public ImClient registerClient(Long userId, String headPortrait, String nickname, Integer deviceType) {
        RegisterClientRequest registerClientRequest =
                RegisterClientRequest.builder()
                        .userId(userId).headPortrait(headPortrait)
                        .nickname(nickname)
                        .build();
        return imClientOperation.registerClient(registerClientRequest);
    }

    private void initOperations() {
        this.imClientOperation = new WecloudImClientOperation(apiDomain, appKey, appSecret);
    }
}
