package com.wecloud.im.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/15 11:29
 * @Description
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ClientInfoVo")
public class ClientInfoVo implements Serializable {

    private static final long serialVersionUID = 1474979499551389791L;

    @ApiModelProperty("client主键id")
    private Long id;

    @ApiModelProperty("会话中client的备注名")
    private String clientRemarkName;

    @ApiModelProperty("头像")
    private String headPortrait;

    @ApiModelProperty("主昵称")
    private String nickname;

    @ApiModelProperty("clientId")
    private String clientId;

    @ApiModelProperty("client自己的自定义扩展属性")
    private String clientAttributes;

    @ApiModelProperty("会话成员列表的自定义扩展属性")
    private String memberAttributes;

    /**
     * 与我关系
     * @see com.wecloud.im.sdk.enums.RelationEnum
     */
    @ApiModelProperty("与我关系 1-陌生人 2-好友 3-被我拉黑")
    private Integer relation;

}
