package com.ym.im.exception;

import com.ym.im.entity.MsgBody;
import com.ym.im.util.MessageUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Locale;
import java.util.UUID;

/**
 * @author 陈俊雄
 * @date 2019/5/31
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class IMessageException extends RuntimeException {

    private MsgBody msgBody;

    private String i18nError;

    private String errorNum = UUID.randomUUID().toString();

    public IMessageException(String i18nError) {
        super(MessageUtils.getMsg(i18nError, Locale.CHINA));
        this.i18nError = i18nError;
        this.msgBody = new MsgBody()
                .setStatus(MsgBody.ERROR)
                .setMessage(MessageUtils.getMsg(i18nError));
    }
}
