package com.jumeirah.common.service;

import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.param.AppUserPageParam;
import com.jumeirah.common.param.app.AppSmsRegisterParam;
import com.jumeirah.common.vo.AppUserQueryVo;
import com.jumeirah.common.vo.app.LoginAppUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * APP用户 服务类
 *
 * @author wei
 * @since 2020-09-23
 */
public interface AppUserService extends BaseService<AppUser> {

    /**
     * 根据手机号判断用户是否存在
     * @param phoneArea
     * @param phone
     * @return
     */
    boolean hasUserByPhoneNumer(String phoneArea,String phone);

//    /**
//     * 注册
//     *
//     * @param appSmsRegisterParam
//     * @param language
//     * @return
//     */
//    ApiResult<LoginAppUserTokenVo> register(AppSmsRegisterParam appSmsRegisterParam, String language);

    /**
     * 登陆
     *
     * @param loginParam
     * @param language
     * @return
     */
    ApiResult<LoginAppUserTokenVo> login(AppSmsRegisterParam loginParam, String language,Boolean hasRegister);


    /**
     * 保存
     *
     * @param appUser
     * @return
     * @throws Exception
     */
    boolean saveAppUser(AppUser appUser) throws Exception;

    /**
     * 修改
     *
     * @param appUser
     * @return
     * @throws Exception
     */
    boolean updateAppUser(AppUser appUser) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteAppUser(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    AppUserQueryVo getAppUserById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param appUserPageParam
     * @return
     * @throws Exception
     */
    Paging<AppUserQueryVo> getAppUserPageList(AppUserPageParam appUserPageParam) throws Exception;

}
