package com.wecloud.im.sdk;

import java.net.URL;
import java.util.List;

import com.wecloud.im.sdk.internal.WecloudImClientOperation;
import com.wecloud.im.sdk.internal.WecloudImConversationOperation;
import com.wecloud.im.sdk.model.ClientLoginRequest;
import com.wecloud.im.sdk.model.Friend;
import com.wecloud.im.sdk.model.GetFriendsRequest;
import com.wecloud.im.sdk.model.GetUnsureFriendsRequest;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.ModifyUserRequest;
import com.wecloud.im.sdk.model.RegisterClientRequest;
import com.wecloud.im.sdk.model.SetConversationDoNotDisturbRequest;
import com.wecloud.im.sdk.model.SetConversationTopRequest;
import com.wecloud.im.sdk.model.Token;
import com.wecloud.im.sdk.model.UnsureFriend;

/**
 *
 * @Author luozh
 * @Date 2022年04月13日 11:23:24
 * @Version 1.0
 */
public class WecloudImClient implements WecloudIm {

    /**
     * 请求地址
     */
    private URL apiDomain;

    /**
     * 蔚可云分配后台分配的appKey
     */
    private String appKey;

    /**
     * 蔚可云分配后台分配的appSecret
     */
    private String appSecret;

    /* The miscellaneous IM operations */
    private WecloudImClientOperation imClientOperation;

    private WecloudImConversationOperation imConversationOperation;

    public WecloudImClient(URL apiDomain, String appKey, String appSecret) {
        this.apiDomain = apiDomain;
        this.appKey = appKey;
        this.appSecret = appSecret;
        initOperations();
    }

    @Override
    public ImClient registerClient(String userId, String headPortrait, String nickname) {
        RegisterClientRequest registerClientRequest =
                RegisterClientRequest.builder()
                        .userId(userId).headPortrait(headPortrait)
                        .nickname(nickname)
                        .build();
        return imClientOperation.registerClient(registerClientRequest);
    }

    @Override
    public Token getToken(String userId, Integer deviceType) {
        ClientLoginRequest clientLoginRequest = ClientLoginRequest.builder().clientId(userId).deviceType(deviceType).build();

        return imClientOperation.getToken(clientLoginRequest);
    }

    @Override
    public Boolean modifyUser(String userId, String nickname, String headPortrait) {
        ModifyUserRequest modifyUserRequest =
                ModifyUserRequest.builder().userId(userId).nickname(nickname).headPortrait(headPortrait).build();

        return imClientOperation.modifyUser(modifyUserRequest);
    }

    @Override
    public List<UnsureFriend> getUnsureFriends(String userId) {
        GetUnsureFriendsRequest getUnsureFriendsRequest = GetUnsureFriendsRequest.builder().userId(userId).build();

        return imClientOperation.getUnsureFriends(getUnsureFriendsRequest);
    }


    @Override
    public List<Friend> getFriends(String userId) {
        GetFriendsRequest getFriendsRequest = GetFriendsRequest.builder().userId(userId).build();
        return imClientOperation.getFriends(getFriendsRequest);
    }

    @Override
    public Boolean setConversationTop(String userId, Long conversationId, Boolean top) {
        SetConversationTopRequest setConversationTopRequest =
                SetConversationTopRequest.builder().userId(userId).conversationId(conversationId).top(top).build();
        return imConversationOperation.setConversationTop(setConversationTopRequest);
    }

    @Override
    public Boolean setConversationDoNotDisturb(String userId, Long conversationId, Boolean doNotDisturb) {
        SetConversationDoNotDisturbRequest setConversationDoNotDisturbRequest =
                SetConversationDoNotDisturbRequest.builder().userId(userId).conversationId(conversationId).doNotDisturb(doNotDisturb).build();
        return imConversationOperation.setConversationDoNotDisturb(setConversationDoNotDisturbRequest);
    }

    private void initOperations() {
        this.imClientOperation = new WecloudImClientOperation(apiDomain, appKey, appSecret);
        this.imConversationOperation = new WecloudImConversationOperation(apiDomain, appKey, appSecret);
    }


}
