package com.wecloud.im.sdk.sample;

import java.util.Date;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;

import com.wecloud.im.sdk.WecloudIm;
import com.wecloud.im.sdk.WecloudImClientBuilder;
import com.wecloud.im.sdk.model.GroupChatMessage;
import com.wecloud.im.sdk.model.message.MessageImageFile;
import com.wecloud.im.sdk.model.message.PicMessage;
import com.wecloud.im.sdk.model.message.TextMessage;

/**
 * 发布群消息
 * @Author luozh
 * @Date 2022年05月06日 01:37:29
 * @Version 1.0
 */
public class PublishGroupChatMessageSample {

    public static void main(String[] args) {
        WecloudIm im = new WecloudImClientBuilder().build("http://139.159.136.86:8082",
                "QizKVHcILRWp6Td2",
                "287d04828099fb7de871e9dda845fa8b6b2302faf2ab3737");

        String senderId = "1519984635566845952";
        String toGroupIds = "1519985463165931520";
        String messageType = "-1";


        boolean silent = true;
        GroupChatMessage groupChatMessage = new GroupChatMessage();
        groupChatMessage.setFromUserId(senderId);
        groupChatMessage.setToGroupIds(toGroupIds);
        groupChatMessage.setPushContent("");
        groupChatMessage.setIncludeSender(false);
        groupChatMessage.setPersisted(true);
        groupChatMessage.setMentioned(false);
        groupChatMessage.setSilent(silent);

        groupChatMessage.setMessageType("-1");
        groupChatMessage.setContent(JSONUtil.toJsonStr(buildTextMessage()));
        Boolean textMessageResult = im.publishGroupChatMessage(groupChatMessage);

        groupChatMessage.setMessageType("-2");
        groupChatMessage.setContent(JSONUtil.toJsonStr(buildPicMessage()));
        Boolean picMessageResult = im.publishGroupChatMessage(groupChatMessage);


    }

    private static TextMessage buildTextMessage() {
        TextMessage textMessage = new TextMessage();
        textMessage.setText("这是text消息测试: " + DateUtil.formatDateTime(new Date()));
        return textMessage;
    }

    private static PicMessage buildPicMessage() {
        PicMessage picMessage = new PicMessage();

        MessageImageFile imageFile = new MessageImageFile();
        imageFile.setUrl("http://ac-p2bpmgci.clouddn.com/246b8acc-2e12-4a9d-a255-8d17a3059d25");
        MessageImageFile.MetaData metaData = new MessageImageFile.MetaData();
        metaData.setName("IMG_20141223.jpeg");
        metaData.setFormat("png");
        metaData.setHeight(768);
        metaData.setWidth(1024);
        metaData.setSize(18);
        imageFile.setMetaData(metaData);

        picMessage.setFile(imageFile);
        return picMessage;
    }


}
