package com.wecloud.im.sdk.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RtcRecordRequest extends WebServiceRequest{
    /**
     * 发送者id
     */
    private String fromClientId;

    /**
     * 接受者id
     */
    private String toClientId;

    /**
     * 房间id
     */
    private String channelId;

    /**
     * 通话记录类型 1视频 2音频
     */
    private Integer callType;

    /***
     * 页码
     */
    private Integer pageNum;

    /**
     * 每页数量
     */
    private Integer pageSize;
}
