package com.wecloud.im.service;

import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.param.ImConversationMembersPageParam;
import com.wecloud.im.param.ImConversationMembersQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 会话成员表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationMembersService extends BaseService<ImConversationMembers> {

        /**
         * 保存
         *
         * @param imConversationMembers
         * @return
         * @throws Exception
         */
        boolean saveImConversationMembers(ImConversationMembers imConversationMembers) throws Exception;

        /**
         * 修改
         *
         * @param imConversationMembers
         * @return
         * @throws Exception
         */
        boolean updateImConversationMembers(ImConversationMembers imConversationMembers) throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteImConversationMembers(Long id) throws Exception;

        /**
         * 根据ID获取查询对象
         *
         * @param id
         * @return
         * @throws Exception
         */
        ImConversationMembersQueryVo getImConversationMembersById(Long id) throws Exception;

        /**
         * 获取分页对象
         *
         * @param imConversationMembersPageParam
         * @return
         * @throws Exception
         */
        Paging<ImConversationMembersQueryVo> getImConversationMembersPageList(ImConversationMembersPageParam imConversationMembersPageParam) throws Exception;

}
