package com.wecloud.im.param.rtc;

import lombok.Data;

import java.io.Serializable;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
@Data
public class RtcRecordParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 发送者id
     */
    private String fromClientId;

    /**
     * 接受者id
     */
    private String toClientId;

    /**
     * 房间id
     */
    private Long channelId;

    /**
     * 音视频类型
     */
    private Integer callType;

    /***
     * 页码
     */
    private Integer pageNum;

    /**
     * 每页数量
     */
    private Integer pageSize;
}
