package com.wecloud.im.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImRtcRecord;
import com.wecloud.im.param.rtc.RtcRecordParam;
import com.wecloud.im.service.ImRtcRecordService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author nanqianhao
 * @date 2022/5/23
 * @apiNote
 */
@Slf4j
@RestController
@RequestMapping("/rtcrecord")
@Api(value = "后台通话记录列表")
public class ImRtcRecordController extends BaseController {

    @Autowired
    private ImRtcRecordService rtcRecordService;

    @PostMapping("/listRtcRecords")
    @ApiOperation(value = "分页获取后台通话记录")
    public ApiResult<Page<ImRtcRecord>> listRtcRecords(@RequestBody RtcRecordParam rtcRecordParam){
        log.info("获取后台通话记录入参 {}", JSON.toJSONString(rtcRecordParam));
        return ApiResult.ok(rtcRecordService.getPageImRtcRecords(rtcRecordParam));
    }

}
