package io.geekidea.springbootplus.config;

import com.wecloud.im.push.huawei.messaging.HuaweiApp;
import com.wecloud.im.push.huawei.util.InitAppUtils;
import com.wecloud.im.service.HuaweiPushServiceImpl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties("wecloudim.huawei")
public class HuaweiConfiguration {
    private String appId;
    private String appSecret;
    private String tokenServer;
    private String pushOpenUrl;

    @Bean(destroyMethod = "delete")
    HuaweiApp huaweiApp(){
        return InitAppUtils.initializeApp(appId,appSecret,tokenServer,pushOpenUrl);
    }

    @Bean
    HuaweiPushServiceImpl huaweiPushServiceImpl(HuaweiApp app){
        return new HuaweiPushServiceImpl(app);
    }


    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getTokenServer() {
        return tokenServer;
    }

    public void setTokenServer(String tokenServer) {
        this.tokenServer = tokenServer;
    }

    public String getPushOpenUrl() {
        return pushOpenUrl;
    }

    public void setPushOpenUrl(String pushOpenUrl) {
        this.pushOpenUrl = pushOpenUrl;
    }
}
