package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImClientBlacklist;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 黑名单 Mapper 接口
 *
 * @author wei
 * @since 2021-06-17
 */
@Repository
public interface ImClientBlacklistMapper extends BaseMapper<ImClientBlacklist> {

    /**
     * 查询我的拉黑列表
     * @param page
     * @param clientId
     * @return
     */
    IPage<ImClientBlacklistQueryVo> getImClientBlacklistPageList(@Param("page") Page page, @Param("clientId") String clientId);

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImClientBlacklistQueryVo getImClientBlacklistById(Serializable id);

//      /**
    //     * 获取分页对象
    //     *
    //     * @param page
    //     * @param imClientBlacklistPageParam
    //     * @return
    //     */
//    IPage<ImClientBlacklistQueryVo> getImClientBlacklistPageList(@Param("page") Page page, @Param("param") ImClientBlacklistPageParam imClientBlacklistPageParam);

}
