package com.wecloud.im.event.listener;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.event.ClientSendMessageEvent;
import com.wecloud.im.service.ImCallbackService;

/**
 *
 * @Author luozh
 * @Date 2022年04月22日 09:48
 * @Version 1.0
 */
@Component
public class ClientSendMessageListener implements ApplicationListener<ClientSendMessageEvent> {

    @Autowired
    private ImCallbackService callbackService;

    @Override
    public void onApplicationEvent(ClientSendMessageEvent event) {
        Long applicationId = event.getApplicationId();
        ImMessage message = event.getMessage();
        callbackService.fullMessageRouting(applicationId, message);
    }
}
