package com.wecloud.multimeet.service;

import com.wecloud.im.param.AgreeToMultiMeetParam;
import com.wecloud.im.param.HeartbeatMultiMeetParam;
import com.wecloud.im.param.InviteToMultiMeetParam;
import com.wecloud.im.param.LeaveFromMultiMeetParam;
import com.wecloud.im.param.NotAnsweredMultiMeetParam;
import com.wecloud.im.param.RejectToMultiMeetParam;

/**
 * @Author wenzhida
 * @Date 2022/3/7 18:26
 * @Description 多人音视频服务接口
 */
public interface MultiMeetService {

    /**
     * 发起多人音视频邀请
     * @param param
     * @return
     */
    void invite(InviteToMultiMeetParam param);

    /**
     * 拒接加入会议
     * @param param
     */
    void reject(RejectToMultiMeetParam param);

    /**
     * 同意进入会议
     * @param param
     */
    void agree(AgreeToMultiMeetParam param);

    /**
     * 同意进入会议
     * @param param
     */
    void leave(LeaveFromMultiMeetParam param);

    /**
     * 拒绝接听
     * @param param
     */
    void notAnswered(NotAnsweredMultiMeetParam param);

    /**
     * 心跳接收
     * @param param
     */
    void heartbeat(HeartbeatMultiMeetParam param);

    /**
     * 呼叫超时逻辑处理
     */
    void callingTimeout();

    /**
     * 异常断线逻辑处理
     */
    void disconnect();

}
