package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.MerchantPermission;
import com.jumeirah.common.param.MerchantPermissionPageParam;
import com.jumeirah.common.vo.MerchantPermissionQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 商家权限 Mapper 接口
 *
 * @author wei
 * @since 2020-09-28
 */
@Repository
public interface MerchantPermissionMapper extends BaseMapper<MerchantPermission> {

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             */
        MerchantPermissionQueryVo getMerchantPermissionById(Serializable id);

            /**
             * 获取分页对象
             *
             * @param page
             * @param merchantPermissionPageParam
             * @return
             */
            IPage<MerchantPermissionQueryVo> getMerchantPermissionPageList(@Param("page") Page page,@Param("param") MerchantPermissionPageParam merchantPermissionPageParam);

        }
