package com.wecloud.netty.dispatch.general.extend.impl;

import com.wecloud.netty.dispatch.ActionDispatcher;
import com.wecloud.netty.dispatch.common.BaseRequest;
import com.wecloud.netty.dispatch.extend.ActionMessage;
import com.wecloud.netty.dispatch.extend.impl.DefaultActionMessage;
import com.wecloud.netty.dispatch.general.extend.ActionMessageResolver;
import org.springframework.stereotype.Component;

/**
 * @author lixiaozhong
 */
@Component
public class ActionMessageResolverImpl implements ActionMessageResolver {

	@Override
	public ActionMessage resolver(ActionDispatcher actionDispatcher, BaseRequest data) {
		ActionMessage am = new DefaultActionMessage();
		am.setAction("");

		if (data == null) {
			return am;
		}

		String action = data.getAction();
		String path = actionDispatcher.getActionRegistry().getPath(action, null);

		am.setMessage(data);
		am.setAction(path);
		return am;
	}

}
