package com.wecloud.im.security.signature;

import lombok.Data;

import org.apache.shiro.authc.HostAuthenticationToken;

import com.wecloud.im.core.util.IpUtil;

/**
 *
 * @Author luozh
 * @Date 2022年04月15日 15:19
 * @Version 1.0
 */
@Data
public class SignatureAuthToken implements HostAuthenticationToken {

    /**
     * 登录ip
     */
    private String host;

    /**
     * appKey
     */
    private String appKey;

    /**
     *  appId
     */
    private Long appId;

    public SignatureAuthToken(String appKey, Long appId) {
        this.appKey = appKey;
        this.appId = appId;
        setHost(IpUtil.getRequestIp());
    }

    @Override
    public Object getPrincipal() {
        return appKey;
    }

    @Override
    public Object getCredentials() {
        return appKey;
    }


}
