package com.wecloud.im.core.util;

import lombok.extern.slf4j.Slf4j;

import org.fusesource.jansi.Ansi;
import org.springframework.core.env.Environment;

/**
 * @author geekidea
 * @date 2018-11-08
 */
@Slf4j
public class AnsiUtil {

    private static final boolean ENABLE_ANSI;

    static {
        Boolean value = false;
        try {
            Environment environment = SpringContextUtil.getBean(Environment.class);
            value = environment.getProperty("spring-boot-plus.enable-ansi", boolean.class);
            value = value == null ? false : value;
        } catch (Exception e) {
            e.printStackTrace();
        }
        ENABLE_ANSI = value;
    }

    public static String getAnsi(Ansi.Color color, String text) {

        if (ENABLE_ANSI) {
            return Ansi.ansi().eraseScreen().fg(color).a(text).reset().toString();
        }
        return text;
    }

    public static String getAnsi(Ansi.Color color, String text, boolean flag) {
        if (flag) {
            return Ansi.ansi().eraseScreen().fg(color).a(text).reset().toString();
        }
        return text;
    }
}
