package com.wecloud.im.core.config.jackson.serializer;

import java.io.IOException;
import java.util.Date;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.wecloud.im.core.util.DateUtil;

/**
 * <p>
 * Jackson Date反序列化器
 * </p>
 *
 * @author geekidea
 * @date 2018-11-08
 */
public class JacksonDateSerializer extends JsonSerializer<Date> {
    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        String string = null;
        if (date != null) {
            string = DateUtil.getDateTimeString(date);
        }
        jsonGenerator.writeString(string);
    }
}
