package com.wecloud.im.core.common.controller;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

import com.wecloud.im.core.log.annotation.OperationLogIgnore;

/**
 * <p>
 * 项目根路径提示信息
 * </p>
 *
 * @author geekidea
 * @date 2018/11/12
 */
@Slf4j
@Controller
@OperationLogIgnore
@Api(value = "Index API", tags = {"Index"})
public class IndexController {

    @GetMapping("/")
    public String home() {
        return "redirect:/index.html";
    }

    /**
     * SwaggerUI
     */
    @GetMapping("/docs")
    public String docs() {
        return "redirect:/swagger-ui.html";
    }

//    /**
//     * SwaggerUI
//     */
//    @GetMapping("/websocketDocs")
//    public String websocket() {
//        return "redirect:/Wecloud-IM-Websocket-Docs.html";
//    }

}
