package com.wecloud.im.biz.module.message.service.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.biz.module.message.controller.param.ImApplicationPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImApplicationQueryVo;
import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.mapper.ImApplicationMapper;
import com.wecloud.im.biz.module.message.service.ImApplicationService;
import com.wecloud.im.core.common.service.impl.BaseServiceImpl;
import com.wecloud.im.core.pagination.PageInfo;
import com.wecloud.im.core.pagination.Paging;
import com.wecloud.im.security.signature.Application;
import com.wecloud.im.security.signature.ApplicationService;

/**
 * 第三方应用表 服务实现类
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@Service
@CacheConfig(cacheNames = "appl")
public class ImApplicationServiceImpl extends BaseServiceImpl<ImApplicationMapper, ImApplication> implements ImApplicationService, ApplicationService {

    @Autowired
    private ImApplicationMapper imApplicationMapper;

    @Override
//    @Cacheable(key = "'id_'+#p0")
    public ImApplication getCacheById(Long id) {
        return super.getById(id);
    }

    @Override
    @CacheEvict(key = "'id_'+#p0")
    public void deleteCacheById(Long id) {
    }

    @Override
    @CacheEvict(key = "'appKey_'+#p0")
    public void deleteCacheByAppKey(String appKey) {
    }

    @Override
    @Cacheable(key = "'appKey_'+#p0")
    public ImApplication getCacheAppByAppKey(String appKey) {
        ImApplication imApplication = this.getOne(
                new QueryWrapper<ImApplication>().lambda()
                        .eq(ImApplication::getAppKey, appKey)
        );
        return imApplication;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveImApplication(ImApplication imApplication) throws Exception {
        return super.save(imApplication);
    }

//    @Transactional(rollbackFor = Exception.class)
//    @Override
//    public boolean updateImApplication(ImApplication imApplication) throws Exception {
//        return super.updateById(imApplication);
//    }
//
//    @Transactional(rollbackFor = Exception.class)
//    @Override
//    public boolean deleteImApplication(Long id) throws Exception {
//        return super.removeById(id);
//    }

    @Override
    public ImApplicationQueryVo getImApplicationById(Long id) throws Exception {
        return imApplicationMapper.getImApplicationById(id);
    }

    @Override
    public Paging<ImApplicationQueryVo> getImApplicationPageList(ImApplicationPageParam imApplicationPageParam) throws Exception {
        Page<ImApplicationQueryVo> page = new PageInfo<>(imApplicationPageParam, OrderItem.desc(getLambdaColumn(ImApplication::getCreateTime)));
        IPage<ImApplicationQueryVo> iPage = imApplicationMapper.getImApplicationPageList(page, imApplicationPageParam);
        return new Paging<ImApplicationQueryVo>(iPage);
    }

    @Override
    public Application getApplication(String appKey) {
        return getCacheAppByAppKey(appKey);
    }
}
