package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

import com.wecloud.im.core.common.entity.BaseEntity;

/**
 * @Author wenzhida
 * @Date 2022/3/8 11:11
 * @Description 给会话消息设置已读入参
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "给会话消息设置已读入参")
public class UpdateMsgReadStatusByConversationParam extends BaseEntity {

    private static final long serialVersionUID = 4378221788952403799L;

    @ApiModelProperty("会话id")
    @NotNull(message = "会话id不能为空")
    private Long conversationId;

    @ApiModelProperty("最新一条消息id 将这条消息及之前的消息全部设置为已读")
    @NotNull(message = "最新一条消息id不能为空")
    private Long msgIdEnd;

}
