package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

import javax.validation.constraints.NotEmpty;

import com.wecloud.im.core.common.entity.BaseEntity;

/**
 * ImMsgReadUpdate
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImMsgReceivedStatusUpdate")
public class ImMsgReceivedStatusUpdate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "消息id数组,可以传入单个或多个, 如接收离线消息列表时可以批量修改 则传入多个", required = true)
    @NotEmpty(message = "msgIds==null")
    private List<Long> msgIds;

    @ApiModelProperty(value = "是否同时修改为已读状态", required = false)
    private Boolean readStatus = false;
}
